//===============================================================================================
// Renders a list of items to purchase
// is responsible for managing the sequence of ipps dialog pages.
//
// Copyright <c> 2003 Intuit, Inc.  All rights reserved
//===============================================================================================

// Sales item object
function zSalesItem(name,price,productCode,sourceCode,licenseCode)
{
	this.name = (name) ? name : "";
	this.price = (price) ? price : 0;
	this.productCode = (productCode) ? productCode : "";
	this.sourceCode = (sourceCode) ? sourceCode : "";
	this.licenseCode = (licenseCode) ? licenseCode : "";
}

//---------------------------------------------------------------------------------------------
function setPurchaseList( items, salesTax, bShowVerify, bShowProductCode, bHidePrice, overflowLineCnt )
	// Render a list of sales items to purchase
{
	if(!items)return;
	if(!overflowLineCnt)overflowLineCnt=2;

	var totalAmt = 0;
	var numItems=items.length;

	// Render the each item
	var tbody = document.getElementById("purchaseList");
	if(tbody)
	{
		var row,cell;
		var cellNum = 0;
		
		for( var i=0; i<numItems; ++i )
		{
			// Add to total price
			totalAmt += items[i].price;
			
			// Render a row for each item
			row = tbody.insertRow(-1);
			cellNum = 0;

			// name
			cell = row.insertCell(cellNum++);
			cell.className = "item";
			if( items[i].name.length < 50 )cell.noWrap = true;
			cell.innerHTML = items[i].name;

			// product code
			if( bShowProductCode )
			{
				cell = row.insertCell(cellNum++);
				cell.className = "code";
				cell.noWrap = true;
				cell.innerHTML = (items[i].productCode) ? items[i].productCode : "&nbsp;";
			
				// source code
				cell = row.insertCell(cellNum++);
				cell.className = "code";
				cell.noWrap = true;
				cell.innerHTML = (items[i].sourceCode) ? items[i].sourceCode : "&nbsp;";
			}
			
			// price
			if(!bHidePrice)
			{
				cell = row.insertCell(cellNum++);
				cell.className = "amount";
				cell.noWrap = true;
				cell.innerHTML = toDollarString(items[i].price);
			}
			
			// verify link
			if( bShowVerify )
			{
				cell = row.insertCell(cellNum++);
				cell.className = "opt";
				cell.noWrap = true;
				cell.innerHTML = taggedValue( "nobr", '<a href="javascript:alert(\'Under Construction\')" helpid="verify">I\'ve already purchased this</a>' );
			}
		}

		if( null!=salesTax ) // could be 0...check for null
		{
			totalAmt += salesTax;

			row = tbody.insertRow(-1);
			cellNum = 0;

			// label
			cell = row.insertCell(cellNum++);
			cell.className = "item";
			cell.noWrap = true;
			//
			// Issue ID: TWTE002019
			// If the Sales Tax is 0, that could mean that the zip code was entered
			// incorrectly.  Or it could mean that there is no sales tax for the 
			// billing state.  
			if (salesTax!=0)
			{
				cell.innerHTML = "Sales tax";
			}
			else
			{
				cell.innerHTML = "&nbsp;";
			}
			
			if( bShowProductCode )
			{
				cell = row.insertCell(cellNum++);
				cell.className = "item";
				cell.innerHTML = "&nbsp;";

				cell = row.insertCell(cellNum++);
				cell.className = "item";
				cell.innerHTML = "&nbsp;";
			}
			
			// amount
			cell = row.insertCell(cellNum++);
			cell.noWrap = true;
			cell.className = "amount";	// just right justifies it.
			if (salesTax!=0)
			{
				cell.innerHTML = toDollarString(salesTax);		
			}
			else
			{
				cell.innerHTML = "plus applicable sales tax";
			}	
		}
	}
	
	// Set the order amount total
	replaceTextById( "totalAmount", toDollarString(totalAmt) );

	// If there are more items that can fit within the dialog, place a scrollbar around the list
	if( numItems>overflowLineCnt )
	{
		var e = document.getElementById("cart");
		if(e) e.className = "cartOverflow";
	}
}
